unit Krok3;

interface

type
  TZamwienie = class
    function Warto: integer;
  end;

  IWeryfikacjaZamwienia = interface
    ['{4CCA1F87-21C2-4755-9E6F-8573B909CE11}']
    procedure WeryfikujZamwienie(aZamwienie: TZamwienie);
  end;

  TWeryfikacjaZamwienia = class(TInterfacedObject, IWeryfikacjaZamwienia)
    procedure WeryfikujZamwienie(aZamwienie: TZamwienie);
  end;

  TRealizacjaZamwienia = class
  private
    FWeryfikacjaZamwienia: IWeryfikacjaZamwienia;
  public
    constructor Create(aWeryfikacjaZamwienia: IWeryfikacjaZamwienia);
    procedure RealizujZamwienie(aZamwienie: TZamwienie);
  end;

procedure RealizujZamwienia3;

implementation

uses
  System.SysUtils;

procedure RealizujZamwienia3;
var
  Zamwienie: TZamwienie;
  RealizacjaZamwienia: TRealizacjaZamwienia;
begin
  RealizacjaZamwienia := TRealizacjaZamwienia.Create(TWeryfikacjaZamwienia.Create);
  try
    Zamwienie := TZamwienie.Create;
    try
      RealizacjaZamwienia.RealizujZamwienie(Zamwienie);
    finally
      Zamwienie.Free;
    end;
  finally
    RealizacjaZamwienia.Free;
  end;
end;

function TZamwienie.Warto: integer;
begin
  Result := Random(1000) + 1
end;

constructor TRealizacjaZamwienia.Create(aWeryfikacjaZamwienia: IWeryfikacjaZamwienia);
begin
  inherited Create;
  FWeryfikacjaZamwienia := aWeryfikacjaZamwienia;
end;


procedure TRealizacjaZamwienia.RealizujZamwienie(aZamwienie: TZamwienie);
begin
  FWeryfikacjaZamwienia.WeryfikujZamwienie(aZamwienie);
end;

{ TWeryfikacjaZamwienia }

procedure TWeryfikacjaZamwienia.WeryfikujZamwienie(aZamwienie: TZamwienie);
begin
  WriteLn('Warto zamwienia: ' + IntToStr(aZamwienie.Warto));
end;

end.
